
/* This program represents one die with faces showing   *
 * values between 1 and 6                               **/

public class Die implements Cloneable {

		private final int MAX = 6; // maximum face value		

		private int faceValue; // current value showing on the die
		
		//--------------------------------------------------------
		// Constructor : sets the initial face value
		//--------------------------------------------------------
		
		public Die() {
			faceValue = 1;
		}
		
		//--------------------------------------------------------
		// Rolls the die and returns the result
		//--------------------------------------------------------

		public int roll() {
			faceValue = (int) (Math.random() * MAX) + 1;
			// return the new face value
			return faceValue;
		}

		//--------------------------------------------------------
		// Face value mutator
		//--------------------------------------------------------
		
		public void setFaceValue(int value) {
			faceValue = value;
		}

		//--------------------------------------------------------
		// Face value accessor 
		//--------------------------------------------------------
		
		public int getFaceValue() {
			return faceValue;
		}

		//--------------------------------------------------------
		// Constructor : sets the initial face value
		//--------------------------------------------------------
		
		// gets called automatically in print and println method

		public String toString() {
			String result = Integer.toString(faceValue);
			return result;						
		}


		public boolean equals(Object obj) {
			
			Die die = (Die) obj;

			if(faceValue == die.getFaceValue())
				return true;
			else
				return false;

		}
		
		public Object clone() {


			try {
				return super.clone();
			} catch(CloneNotSupportedException cne) {
				return null;
			}


		}

}


